//
//  TodoListChooser.swift
//  Do It
//
//  Created by Jim Dovey on 1/27/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

struct TodoListChooser: View {
    var body: some View {
        NavigationView {
            List {
                Section {
                    // START:AllItems
                    NavigationLink(destination: TodoList()) {
                        Row(name: "All Items",
                            icon: "list.bullet",
                            color: .gray)
                    }
                    // END:AllItems
                }

                Section {
                    ForEach(todoLists) { list in
                        NavigationLink(destination: TodoList(list: list)) {
                            Row(name: list.name,
                                icon: list.icon,
                                color: list.color.uiColor)
                        }
                    }
                }
            }
            .font(.system(.headline, design: .rounded))
            .listStyle(GroupedListStyle())
            .navigationBarTitle("Lists")
        }
    }

    struct Row: View {
        var name: String
        var icon: String
        var color: Color

        // START:LocalizedListName
        var body: some View {
            HStack {
                Image(systemName: icon)
                    .foregroundColor(.white)
                    .frame(width: 32, height: 32)
                    .background(color)
                    .clipShape(Circle())
                // START_HIGHLIGHT
                Text(LocalizedStringKey(name))
                // END_HIGHLIGHT
            }
        }
        // END:LocalizedListName
    }
}

struct TodoListChooser_Previews: PreviewProvider {
    static var previews: some View {
        TodoListChooser()
//            .environment(\.locale, Locale(identifier: "ar"))
//            .environment(\.layoutDirection, .rightToLeft)
    }
}
